﻿using Edu.Library.Collections;
using Microsoft.CodeAnalysis.CSharp.Scripting;
using Microsoft.CodeAnalysis.Scripting;
using System;
using System.CodeDom.Compiler;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Reflection.Emit;
using System.Text;
using System.Threading.Tasks;

namespace Edu.Library
{
    public class CSharpCode
    {
        // https://itnext.io/getting-start-with-roslyn-c-scripting-api-d2ea10338d2b
        public static async Task<int> Execute(string code, CancellationToken cancelToken)
        {
            var sb = new StringBuilder();

            // inject code at the begining
            // preferable to not inject code here as it will result in an incorrect line number value in case of exceptions
            //sb.AppendLine("");

            // code
            sb.AppendLine(code);
            // inject code at the end
            sb.AppendLine("Esy.DrawTurtle(Color.DarkRed, Color.DarkBlue);");
            
            //var script = CSharpScript.Create(code, null);
            Esy.Reset();
            var result = await CSharpScript.EvaluateAsync<int>(
                sb.ToString(),
                ScriptOptions.Default
                    .WithImports(
                        "System",
                        "System.IO",
                        "System.Drawing",
                        "System.Text",
                        "System.Linq", 
                        "System.Collections", 
                        "System.Collections.Generic", 
                        "Edu.Library",
                        "Edu.Library.Helpers",
                        "Edu.Library.Collections",
                        "Edu.Library.Mathematics",
                        "Edu.Library.Logo"
                    )
                    .WithReferences(typeof(Esy).Assembly),
                    cancellationToken: cancelToken
                //globals: new ArgsWrapper { } eduInOut
                ); 

            return result;
                //.GetAwaiter()
                //.GetResult();

            
        }
    }
}
